PROBLEM_ANALYSIS_PROMPT = """
Analyze the given coding problem and provide a concise summary of the key requirements, constraints, and expected functionality. Focus on identifying the core logic needed to solve the problem.

Problem:
{input}

Provide a brief analysis of the problem, highlighting the main aspects that need to be addressed in the solution.
"""

GENERATE_TEST_CASES_PROMPT = """
Generate a set of comprehensive test cases for the given problem. Include edge cases, normal cases, and any special scenarios that should be considered.

{input}

Provide a list of test cases, each with input and expected output.
"""

CODE_GENERATE_PROMPT = """
Generate a Python function that solves the given problem. Make sure to include any necessary imports and follow best practices for code readability and efficiency.

Problem:
{problem}

Entry point:
{entry_point}

Your task is to implement the function described above. Provide only the code, without any explanations or comments.
"""

ERROR_ANALYSIS_PROMPT = """
Analyze the given error and provide a detailed explanation of what might be causing it. Consider edge cases, input validation, and potential logical errors in the implementation.

{input}

Provide a concise analysis of the error, focusing on the root cause and potential fixes.
"""

IMPROVE_SOLUTION_PROMPT = """
The previous solution failed to pass the test cases. Please improve the solution based on the provided error analysis, problem analysis, and test cases. Focus on fixing the specific issues mentioned in the error message and ensure the function works correctly for all test cases.

{input}

Provide only the improved code, without any explanations or comments.
"""